package uppaal;

import model.*;
import java.util.ArrayList;
import java.io.*;

public class TrackConvert {

    public static void main(String[] args) {
	Track track = tracks.MazeTrack.createTrack();
	TrackConvert converter = new TrackConvert();
	converter.convert(track);
    }

    public void convert(Track track) {
	String theFile = new String();
	
	try {
	    PrintStream stringWriter = new PrintStream(new FileOutputStream("uppaal/VectorRace.xml",false));
	    
	    ArrayList decl = declaration(track);
	    for(int i = 0; i < decl.size(); i++) {
		stringWriter.println((String)decl.get(i));
	    }
	    
	    stringWriter.close();
	} catch (Exception e) {
	    System.err.println("ERROR: Write to file failed");
	}
    }

    private ArrayList declaration(Track track) {
	LineSegment goal = track.goalLine;
	Vector start = (Vector)track.legalStartingPoints.get(0);
	ArrayList contour = track.contour;
	ArrayList decl = new ArrayList();
	String strDecl = "";
	decl.add("<?xml version='1.0' encoding='utf-8'?>");
	decl.add("<!DOCTYPE nta PUBLIC '-//Uppaal Team//DTD Flat System 1.0//EN' 'http://www.docs.uu.se/docs/rtmv/uppaal/xml/flat-1_0.dtd'>");
	decl.add("<nta>");
	
	decl.add("<declaration>");
	decl.add("// Track");
	decl.add("const int trx = " + track.topRight.x + ";");
	decl.add("const int try = " + track.topRight.y + ";");
	decl.add("const int blx = " + track.bottomLeft.x + ";");
	decl.add("const int bly = " + track.bottomLeft.y + ";");
	decl.add("//The obstacles");
	decl.add("const int b[" + contour.size() + "][4] := {");
	for(int i = 0; i < contour.size(); i++) {
	    LineSegment c = (LineSegment)contour.get(i);
	    if (i != 0) strDecl+=","; 
	    strDecl+= "{" + c.A.x + "," + c.A.y + "," + c.r.x + "," + c.r.y + "}";
	}
	strDecl += "};";
	decl.add(strDecl);
	decl.add("//The speed vector");
	decl.add("int[" + (-(track.topRight.x - track.bottomLeft.x)) + "," + track.topRight.x + "] dx;");
	decl.add("int[" + (-(track.topRight.y - track.bottomLeft.y)) + "," + track.topRight.y + "] dy;");
	decl.add("// Position and number of obstacles");
	decl.add("int[" + track.bottomLeft.x + "," + track.topRight.x + "] x = " + start.x + ";");
	decl.add("int[" + track.bottomLeft.y + "," + track.topRight.y + "] y = " + start.y + ";");
	decl.add("const int wallMax = " + contour.size() + ";");
	decl.add("int[0," + contour.size() + "] wall;");
	decl.add("// Sync. labels between Car and Checker");
	decl.add("chan check, ok;");
	decl.add("// Goal");
	decl.add("const int goal[4] = {" + goal.A.x + "," + goal.A.y + "," + goal.r.x + "," + goal.r.y + "};");
	decl.add("// Crossing D");
	decl.add("const int cx = " + track.crossingDirection.x + ";");
	decl.add("const int cy = " + track.crossingDirection.y + ";");
    
	return decl;
    }
}