/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : MazeTrack.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-04
 *       last changes : 2005-03-04
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package tracks;

// IMPORT ====================================================================
import java.util.ArrayList;
import junit.framework.*;
import model.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class MazeTrack {

    public static Track createTrack() {
        Track track;

        // A simple square track
        ArrayList contour = new ArrayList();
        contour.add(new LineSegment(new Vector( 0, 4), new Vector( 3, 0)));
        contour.add(new LineSegment(new Vector( 3, 0), new Vector( 0, 4)));
        contour.add(new LineSegment(new Vector( 9, 0), new Vector( 0, 2)));
        contour.add(new LineSegment(new Vector( 9, 2), new Vector( 5, 0)));
        contour.add(new LineSegment(new Vector( 0, 7), new Vector( 6, 0)));
        contour.add(new LineSegment(new Vector( 6, 2), new Vector( 0, 5)));
        contour.add(new LineSegment(new Vector( 6, 5), new Vector( 5, 0)));

        // Goal in the top end of the track
        LineSegment goalLine = new LineSegment(
                                 new Vector(1,7), new Vector(0,2));
        Vector crossingDirection = new Vector(-1,0);

        // Starting points on top of the goal line
        ArrayList legalStartingPoints = new ArrayList();
        legalStartingPoints.add(new Vector(1,5));
        legalStartingPoints.add(new Vector(1,6));

        track = new Track(new Vector(0,0), new Vector(14,9), contour,
            legalStartingPoints, goalLine, crossingDirection);

        return track;
    }
}
