/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : Track.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-02
 *       last changes : 2005-03-03
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package model;

// IMPORT ====================================================================
import java.util.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class Track {
    public Vector bottomLeft, topRight;
    public ArrayList contour, legalStartingPoints;
    public LineSegment goalLine;
    public Vector crossingDirection;

    public Track(Vector bottomLeft, Vector topRight, ArrayList contour, 
            ArrayList legalStartingPoints, LineSegment goalLine, 
            Vector crossingDirection) {
        this.bottomLeft          = bottomLeft;
        this.topRight            = topRight;
        this.contour             = contour;
        this.legalStartingPoints = legalStartingPoints;
        this.goalLine            = goalLine;
        this.crossingDirection   = crossingDirection;
    }

    // A crash happens if 'ls' intersects with a wall OR is out of bounds OR
    // passes the goal line in the wrong direction
    public boolean crash(LineSegment ls) {
        boolean crash = false;

        // check for out of bounds
        Vector endPoint = ls.A.add(ls.r);
        if(!(endPoint.x > bottomLeft.x && endPoint.x < topRight.x
          && endPoint.y > bottomLeft.y && endPoint.y < topRight.y))
            crash = true;

        // check for intersection with any wall
        LineSegment wall;
        for(Iterator i = contour.iterator(); i.hasNext() && !crash;) {
             wall = (LineSegment) i.next();
             if(ls.intersectsWith(wall)) crash = true;
        }

        // check for intersection with goal line
        if(passesGoalLine(ls)) {
            // if it is not a legal crossing, crash
            if(!ls.legalCrossing(goalLine, crossingDirection)) 
                crash = true;
        }

        return crash;
    }

    public int getSize() {
	return getWidth() * getHeight();
    }

    public int getWidth() {
	return topRight.x - bottomLeft.x - 1;
    }

    public int getHeight() {
	return topRight.y - bottomLeft.y - 1;
    }

    // returns true if 'ls' intersects with the goal line (in any direction)
    public boolean passesGoalLine(LineSegment ls) {
        return ls.intersectsWith(goalLine);
    }

    // returns true if 'ls' starts from a legal starting point
    public boolean startsFromLegalStartingPoint(LineSegment ls) {

        boolean s = false;

        for(Iterator i = legalStartingPoints.iterator(); i.hasNext() && !s;) {
            Vector lsp = (Vector) i.next();
            if(ls.A == lsp) s = true;
        }

        return s;
    }

    public void draw(java.awt.Graphics g) {
	new LineSegment(bottomLeft, 
                new Vector(0, topRight.y - bottomLeft.y)).draw(g); // left
	new LineSegment(topRight,   
                new Vector(bottomLeft.x - topRight.x, 0)).draw(g); // top
	new LineSegment(topRight,   
                new Vector(0, bottomLeft.y - topRight.y)).draw(g); // right
	new LineSegment(bottomLeft, 
                new Vector(topRight.x - bottomLeft.x, 0)).draw(g); // bottom
	for (int i = 0; i < contour.size(); i++) {
	    ((LineSegment)contour.get(i)).draw(g);
	}
	for (int i = 0; i < legalStartingPoints.size(); i++) {
	    ((Vector)legalStartingPoints.get(i)).draw(g);
	}
	goalLine.draw(g, java.awt.Color.red);
    }
}
