/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : Configuration.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-03
 *       last changes : 2005-03-03
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package model;

// IMPORT ====================================================================
import java.util.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class Configuration {
    public Vector a, v;
    public int move;

    public Configuration(Vector a, Vector v) {
        this.a = a;
        this.v = v;
    }

    public Configuration(Vector a, Vector v, int m) {
	this(a,v);
	this.move = move(m);
    }

    public boolean equals(Configuration other) { 
	return a.equals(other.a) && v.equals(other.v); 
    }

    public int move(int m) {
	// 8 | 1 | 2
	// 7 | 9 | 3
	// 6 | 5 | 4
	switch (m) {
	    case 1: return 1;
	    case 2: return 5;
	    case 3: return 3;
	    case 4: return 7;
	    case 5: return 2;
	    case 6: return 8;
	    case 7: return 4;
	    case 8: return 6;
	    default: return 0;
	}
    }

    public String toString() {
	return "[" + a + "," + v + "]";
    }

    public void draw(java.awt.Graphics g) {
	g.setColor(java.awt.Color.blue);
	g.drawLine(util.ScaleModelToDisplay.scaleX(a.x,g),
		   util.ScaleModelToDisplay.scaleY(a.y,g),
		   util.ScaleModelToDisplay.scaleX(a.x - v.x,g),
		   util.ScaleModelToDisplay.scaleY(a.y - v.y,g));
	int[] xpoints = {util.ScaleModelToDisplay.scaleX(a.x - v.x,g),
			 util.ScaleModelToDisplay.scaleX(a.x - v.x,g)-30,
			 util.ScaleModelToDisplay.scaleX(a.x - v.x,g)+30};
	int[] ypoints = {util.ScaleModelToDisplay.scaleY(a.y - v.y,g),
			 util.ScaleModelToDisplay.scaleY(a.y - v.y,g)-30,
			 util.ScaleModelToDisplay.scaleY(a.y - v.y,g)+30};
	g.fillPolygon(xpoints, ypoints, 3);
    }
}
