/*
 * Created on Dec 1, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import java.awt.geom.*;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Waypoint {
	public static final int RIGHT = 0;
	public static final int LEFT = 1;
	public static final int BIDIR = 2;
	
	private double x1;
	private double y1;
	private double x2;
	private double y2;
	private int dir;
	private double angle;
	private double revAngle;
	
	public Waypoint(double x1, double y1, double x2, double y2, int dir){
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
		this.dir = dir;
		this.angle = Math.atan2(y2-y1,x2-x1);
		this.angle = (angle < 0? 2*Math.PI:0) + angle;
		this.revAngle = (angle + Math.PI)%(2*Math.PI);
	}
	
	public double getX1(){
		return x1;
	}
	public double getY1(){
		return y1;
	}
	public double getX2(){
		return x2;
	}
	public double getY2(){
		return y2;
	}
	public double getAngle(){
		return angle;
	}
	public void getCoords(double[] c){
		c[0] = x1;
		c[1] = y1;
		c[2] = x2;
		c[3] = y2;
	}
	public int getDirection(){
		return dir;
	}
	/*
	 *  Return value:	0 :	Move did not intersect waypoint
	 * 			1 :	intersected correct direction
	 * 			-1:	intersected opposite direction
	 */
	public int requirementMet(int tx1, int ty1, int tx2, int ty2){
		if (Line2D.linesIntersect(x1,y1,x2,y2,tx1,ty1,tx2,ty2)){
			if (Line2D.ptLineDist(x1,y1,x2,y2,tx1,ty1) == 0){//Crossed when arrow hits, and not again when tail hits.
				return 0;
			}
			double tangle = Math.atan2(ty2-ty1,tx2-tx1);
			tangle = (tangle < 0? 2*Math.PI:0) + tangle;
			double compareAngle = tangle-angle;
			compareAngle = (compareAngle < 0? 2*Math.PI:0) + compareAngle;			
			if (dir == RIGHT){
				//System.out.println("Crossing " + Math.toDegrees(angle)+ " (rev:" + Math.toDegrees(revAngle) + ") with " + Math.toDegrees(tangle)+ " ( " + Math.toDegrees(compareAngle) + ") success? " + (compareAngle >= Math.PI));
				return ( compareAngle >= Math.PI?1:-1);
			}
			if (dir == LEFT){
				return (compareAngle <= Math.PI?1:-1);
			}
			return 1;
		}
		//System.out.print(" ni ");
		return 0;
	}
	public int requirementMet(State s){
		return requirementMet(s.getVector().x,s.getVector().y,s.getVector().x+s.getVector().vx,s.getVector().y+s.getVector().vy);
	}
}
