package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
/*
 * Created on Nov 23, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class PlayerView extends JPanel implements ChangeListener, MouseListener {
	private Game game = null;
	private Color bg = Color.WHITE;
	private int numTicks = 0;
	public PlayerView(Game game){
		
		this.game = game;
		this.game.addChangeListener(this);
		addMouseListener(this);
		
		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		this.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		this.initPlayers();
	}

	/* (non-Javadoc)
	 * @see ChangeListener#changed()
	 */
	public void initPlayers(){
		if (game.gameStarted()){
			this.removeAll();
			PlayerPanel tmpPPanel = null;
			for(int j= 0; j<game.getNumberPlayers();j++){
				tmpPPanel = new PlayerPanel(game.getPlayer(j));
				this.add(tmpPPanel);						
			}
			revalidate();
		}
	}
	public void changed(int e) {
		if(e == Game.EVENT_NEXTPLAYER){
			numTicks = 0;
			((PlayerPanel)this.getComponent(game.getCurrentPlayer())).updateTimeBar(numTicks,game.getTimeLimit());
		}
		if (e == Game.EVENT_TICK){
			numTicks++;
			//System.out.println(""+game.getCurrentPlayer() + "antal comps:"+this.getComponentCount());
			((PlayerPanel)this.getComponent(game.getCurrentPlayer())).updateTimeBar(numTicks,game.getTimeLimit());			
		}
		if (e == Game.EVENT_NEWGAME){
			numTicks=0;
			initPlayers();
		}
			if (game.gameStarted() || game.gameFinished()){
			//for lkken er undvendig som jeg ser det. alts en rask lille optimering
			//for(int j= 0; j<game.getNumberPlayers();j++){ 
			//	((PlayerPanel)this.getComponent(j)).updateDataToPanels(game.getPlayer(j));			
			//}
			int prev;
			if (game.getCurrentPlayer() == 0){
				prev = game.getNumberPlayers()-1;
			} else {
				prev = game.getCurrentPlayer()-1;
			}
			((PlayerPanel)this.getComponent(game.getCurrentPlayer())).updateDataToPanels(game.getPlayer(game.getCurrentPlayer()));	
			((PlayerPanel)this.getComponent(game.getCurrentPlayer())).updateWPBar(game.getPlayer((game.getCurrentPlayer())).getCurrentState().getCurrentWaypoint(),game.getMap().getWaypoints().length-1);
			//Also update the previous player
			((PlayerPanel)this.getComponent(prev)).updateDataToPanels(game.getPlayer(prev));	
			((PlayerPanel)this.getComponent(prev)).updateWPBar(game.getPlayer(prev).getCurrentState().getCurrentWaypoint(),game.getMap().getWaypoints().length-1);
		}	
	}
	
	public void setBackground(Color col){
		bg = col;
	}
	
	//public void paintComponent(Graphics g){
	//	Graphics2D g2 = (Graphics2D) g;
	//}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
		//System.exit(0);
		
		if (e.getButton() == MouseEvent.BUTTON1){
			//System.out.println("Mouse button pressed!");
		}
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {		
		
	}

}
