/*
 * Created on Nov 23, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class GameView  extends JPanel implements ChangeListener, MouseListener, MouseMotionListener{
	private Game game = null;
	private Color bg = new Color(200,200,100);
	private GeneralPath grid = null;
	private int pxPerGrid = 12;
	private double dotradius = 0.2;//percentage of pxPerGrid
	int realOffX = 0;
	int realOffY = 0;
	int stdOffX = 0;
	int stdOffY = 0;
	int prefX = 0;
	int prefY = 0;
	private final int X = 0;
	private final int Y = 1;
	private int hoverMove = -1;
	private float borderWidth = 0.15f;
	private Stroke borderStroke = new BasicStroke(borderWidth);
	private Stroke stdStroke = new BasicStroke(0.1f);
	private Stroke waypointStroke = new BasicStroke(0.08f);
	private Stroke gridStroke = new BasicStroke(0.04f);
	private Area goalLine = null;
	private Color goalLineColor = new Color(200,200,200);
	
	public GameView(Game game){
		this.game = game;
		game.addChangeListener(this);
		this.setBackground(bg);
		addMouseListener(this);
		addMouseMotionListener(this);
		initialize();
	}
	
	public void initialize(){
		Rectangle2D mapsize = game.getMap().getCircuit().getBounds2D();
		stdOffX = (int) (1-Math.floor(mapsize.getX()));
		stdOffY = (int) (1-Math.floor(mapsize.getY()));
		realOffX = stdOffX;
		realOffY = stdOffY;
		prefX = (int) Math.ceil(mapsize.getWidth()+4);
		prefY= (int) Math.ceil(mapsize.getHeight()+4);
		//System.out.println(Math.floor(mapsize.getY()));
		setPreferredSize(new Dimension(prefX*pxPerGrid,prefY*pxPerGrid));
		goalLine = null;
		grid = null;
		revalidate();
	}
	
	
	public void changed(int e){
		if (e == Game.EVENT_NEWMAP){
			//System.out.println("Map Changed");
			initialize();
		}
		if (e != Game.EVENT_TICK){
			repaint();
		}
	}
	
	private GeneralPath getGrid(){
		if (grid == null){
			Shape map = game.getMap().getCircuit();
			Rectangle2D bound = map.getBounds2D();
			grid = new GeneralPath();
			int x = (int)Math.floor(bound.getX());
			int y = (int)Math.floor(bound.getY());
			int w = (int)Math.ceil(bound.getWidth());
			int h = (int)Math.ceil(bound.getHeight());
			//Vertical lines
			for (int i = 0; i <= w;i++){
				grid.append(new Line2D.Double(x+i,y,x+i,y+h),false);
			}
			//Horizontal lines
			for (int i = 0; i <= h;i++){
				grid.append(new Line2D.Double(x,y+i,x+w,y+i),false);
			}
		}
		return grid;
	}

	public void paintWaypoint(Graphics2D g2, Waypoint wp){
		g2.setStroke(waypointStroke);
		g2.setColor(Color.black);
		double[] faf = new double[4];
		wp.getCoords(faf);
		double ttt = wp.getDirection();
		g2.draw(new Line2D.Double(faf[0],faf[1],faf[2],faf[3]));
		//g2.draw(Game.getArrow(faf[0],faf[1],faf[2],faf[3],1,45));
		if(ttt != Waypoint.BIDIR){
			double lx1 = 0.5*(faf[0]+faf[2]) + 0.7*Math.cos(wp.getAngle()    +   (ttt == Waypoint.RIGHT? Math.PI/2 : -Math.PI/2));
			double ly1 = 0.5*(faf[1]+faf[3]) + 0.7*Math.sin(wp.getAngle()     +   (ttt == Waypoint.RIGHT? Math.PI/2 : -Math.PI/2));
			double lx2 = 0.5*(faf[0]+faf[2]) + 0.7*Math.cos(wp.getAngle()    +   (ttt == Waypoint.RIGHT? -Math.PI/2 : Math.PI/2));
			double ly2 = 0.5*(faf[1]+faf[3]) + 0.7*Math.sin(wp.getAngle()     +   (ttt == Waypoint.RIGHT? -Math.PI/2 : Math.PI/2));
			g2.draw(new Line2D.Double(lx1,ly1,lx2,ly2));
			g2.fill(Game.getArrow(lx1,ly1,lx2,ly2,0.4,30));
		}
		
	}
	public void paintGoalLine(Graphics2D g2){
		if (goalLine == null){
			int wps = game.getMap().getWaypoints().length;
			Waypoint goal = game.getMap().getWaypoints()[wps-1];
			GeneralPath pat = new GeneralPath();
			boolean first = true;
			PathIterator it = Game.getArrow(goal.getX1(),goal.getY1(),goal.getX2(),goal.getY2(),1,90).getPathIterator(null);
			double[] coor = new double[2];
			while (!it.isDone()){
				it.currentSegment(coor);
				if (first){
					pat.moveTo((float)coor[0],(float)coor[1]);
					first = false;
				} else {
					pat.lineTo((float)coor[0],(float)coor[1]);
				}
				it.next();
			}
			it = Game.getArrow(goal.getX2(),goal.getY2(),goal.getX1(),goal.getY1(),1,90).getPathIterator(null);
			while (!it.isDone()){
				it.currentSegment(coor);
				pat.lineTo((float)coor[0],(float)coor[1]);
				it.next();
			}
			pat.closePath();
			goalLine = new Area(pat);
			goalLine.intersect(new Area(game.getMap().getCircuit()));
			}
		g2.setColor(goalLineColor);
		g2.setStroke(new BasicStroke(0.02f));
		g2.fill(goalLine);
//		g2.setColor(Color.black);
//		g2.draw(goalLine);
	}

	public void paintHistory(Graphics2D g2){
		for (int i = 0; i < game.getNumberPlayers();i++){
			g2.setColor(game.getPlayer(i).getColor());
			g2.draw(game.getPlayer(i).getHistory());
		}		
	}
	
	public void paintArrow(Graphics2D g2){
		for (int i = 0; i < game.getNumberPlayers();i++){
			g2.setColor(game.getPlayer(i).getColor());
			g2.fill(game.getPlayer(i).getArrowHistory());
		}
	}
	
	public void paintComponent(Graphics g){            
		//super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		Dimension dim = this.getSize();
		g2.setColor(bg);
		g2.fill(new Rectangle2D.Double(0,0,dim.width,dim.height));
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.scale(pxPerGrid,pxPerGrid);

		realOffX = stdOffX;
		realOffY = stdOffY;
		if (game.gameStarted()){
			int xlow, ylow,xhigh,yhigh;
			xlow = game.getPlayer(game.getCurrentPlayer()).getCurrentState().getVector().x+game.getPlayer(game.getCurrentPlayer()).getCurrentState().getVector().vx-1;
			xhigh = xlow+2;
			ylow = game.getPlayer(game.getCurrentPlayer()).getCurrentState().getVector().y+game.getPlayer(game.getCurrentPlayer()).getCurrentState().getVector().vy-1; 
			yhigh = ylow+2;
			//Handle the low parts
			realOffX = Math.max(stdOffX,1-xlow);
			realOffY = Math.max(stdOffY,1-ylow);
			//STILL NEED Y
			if ((xhigh+stdOffX) >= ((int)Math.max(prefX,dim.getWidth()/pxPerGrid))){
				realOffX = 1-(xhigh + 2 - ((int)Math.max(prefX,dim.getWidth()/pxPerGrid)));
			}
			if ((yhigh+stdOffY) >= ((int)Math.max(prefY,dim.getHeight()/pxPerGrid))){
				realOffY = 1-(yhigh + 2 - ((int)Math.max(prefY,dim.getHeight()/pxPerGrid)));
			}
			
			//setPreferredSize(new Dimension((prefX+10)*pxPerGrid,prefY*pxPerGrid));
		}		

		//System.out.println("offx " + offX + " offy " + offY);
		g2.translate(realOffX,realOffY);
		//g2.translate(0,3);
		g2.setColor(Color.white);
		g2.fill(game.getMap().getCircuit());
		
		if (game.showGrid()){
			g2.setColor(bg);
			g2.setStroke(gridStroke);
			g2.draw(getGrid());
		}
		
		//Draw goal line
		paintGoalLine(g2);

		g2.setStroke(borderStroke);
		g2.setColor(Color.black);
		g2.draw(game.getMap().getCircuit());
		
		if (MapFactory.MAP_IN_USE == MapFactory.MAP_CISS){
			g2.drawString("ISS",3f,4.5f);
		}
		
		g2.setColor(Color.black);
		g2.setStroke(stdStroke);
		if (game.gameFinished()){
			paintHistory(g2);
			paintArrow(g2);
		}
		if (game.gameStarted()){
			if (game.showHistory()){
				paintHistory(g2);	
			}
			if (game.showArrowHistory()){			
				paintArrow(g2);			
			}
			/*
			 * Draw current position og each player.
			 */
			for (int i = 0; i < game.getNumberPlayers();i++){
				g2.setColor(game.getPlayer(i).getColor());
				g2.fill(new Area(Game.getArrow(game.getPlayer(i).getCurrentState().getVector().x,game.getPlayer(i).getCurrentState().getVector().y,game.getPlayer(i).getCurrentState().getVector().x,game.getPlayer(i).getCurrentState().getVector().y-Game.ARROWLENGTH,1.5*Game.ARROWLENGTH,Game.ARROWANGLE)));
			}
			//Paint current Player Waypoint
			paintWaypoint(g2,game.getMap().getWaypoints()[game.getPlayer(game.getCurrentPlayer()).getCurrentState().getCurrentWaypoint()]);
			
			//Transition[] trans = game.getMoves();
			int x, y, vx, vy;
			for (int i = 0; i < game.currMoves.length; i++){
				if (game.currMoves[i] != null){
					g2.setColor(game.getCurrentPlayerColor());
					g2.fill(new Ellipse2D.Double((game.currMoves[i].getState().getVector().x+game.currMoves[i].getState().getVector().vx)-dotradius, (game.currMoves[i].getState().getVector().y+game.currMoves[i].getState().getVector().vy)-dotradius, 2*dotradius,2*dotradius));
					for (int j = 0; j < game.currMoves[i].getActual().size();j++){
						g2.setColor(game.getCurrentPlayerColor());
						State theMove = ((State)game.currMoves[i].getActual().elementAt(j));
						x = theMove.getVector().x;
						y = theMove.getVector().y;
						vx = theMove.getVector().vx;
						vy = theMove.getVector().vy;
						//System.out.println("x: " + x + " y: " + y + " vx: " + vx + " vy: "+ vy);
						if (hoverMove == i){
							//System.out.println("hovermove set:  " + hoverMove);
							if(theMove.isCrash() || x != game.currMoves[i].getState().getVector().x || y != game.currMoves[i].getState().getVector().y 
									|| vx != game.currMoves[i].getState().getVector().vx || vy != game.currMoves[i].getState().getVector().vy){
								g2.setColor(Color.red);
							}
							g2.draw(new Line2D.Double(x,y,x+vx,y+vy));
							g2.fill(Game.getArrow(x,y,x+vx,y+vy,Game.ARROWLENGTH,Game.ARROWANGLE));
						}
					}
				}
			}
		}
		//g2.draw(game.getMap().getComplement());
		//System.out.println("Painted!");
		//g2.fill(new Ellipse2D.Double(4-dotradius, 40-dotradius, 2*dotradius,2*dotradius));
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
		
		if (e.getButton() == MouseEvent.BUTTON1){
			//System.out.println("Mouse button pressed! x: " + snapify(e.getX(),X) + " y: " + snapify(e.getY(),Y));
			int cx = snapify(e.getX(),X);
			int cy = snapify(e.getY(),Y);
			if (game.currMoves != null){
				//burde vre noget som repaint(rectangle of influence)
				for (int i = 0; i < game.currMoves.length; i++){
					if (game.currMoves[i] != null){
						int x = game.currMoves[i].getState().getVector().x;
						int y = game.currMoves[i].getState().getVector().y;
						int vx = game.currMoves[i].getState().getVector().vx;
						int vy = game.currMoves[i].getState().getVector().vy;
						if (cx == (x+vx) && cy == (y+vy)){
							hoverMove = -1;
							game.selectMove(i);
							return;
						}
					}
				}
			}
		}
	}

	public int snapify(double d, int xy){
		double gridy = d/pxPerGrid;
		if (gridy-Math.floor(gridy) < 0.5)
			return  (int) Math.floor(gridy) - (xy==X?realOffX:realOffY);
		else
			return (int) Math.ceil(gridy) - (xy==X?realOffX:realOffY);
	}
	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {		
		
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e) {
		if (game.currMoves != null){
			int cx = snapify(e.getX(),X);
			int cy = snapify(e.getY(),Y);
			for (int i = 0; i < game.currMoves.length; i++){
				if (game.currMoves[i] != null){
					int x = game.currMoves[i].getState().getVector().x;
					int y = game.currMoves[i].getState().getVector().y;
					int vx = game.currMoves[i].getState().getVector().vx;
					int vy = game.currMoves[i].getState().getVector().vy;
					if (cx == (x+vx) && cy == (y+vy)){
						hoverMove = i;
						repaint();
						return;
					}
				}					
			}
		}
		if (hoverMove >= 0){
			hoverMove = -1;
			repaint();
		}
	}
}
