/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : PathFinderIterationAnalysis.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-16
 *       last changes : 2005-03-16
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package analysis;

// IMPORT ====================================================================
import java.util.ArrayList;
import model.*;
import display.*;
import algorithms.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class PathFinderAnalysis {

    public void iterationAnalysis(PathFinder pf, int lowSize, int highSize, boolean quiet) {
	iterationAnalysis(pf, lowSize, highSize, quiet, 0);        
    }

    public void iterationAnalysis(PathFinder pf, int lowSize, int highSize, boolean quiet, int repeat) {
	if (repeat < 0) {
	    repeat = 0;
	}
	Vector bl = new Vector();
        Vector tr = new Vector();
        LineSegment goal;

        // crossing direction: right
        Vector cd = new Vector();
        cd.x = 1; cd.y = 0;

        ArrayList lsp = new ArrayList();

        // no contours on the track
        ArrayList con = new ArrayList();

        // clear screen
	//System.out.println ((char)27 + "[2J");

	//Caption
        String caption = "Analysis of " + pf.getClass().getName() + " algorithm ";
        while(caption.length() < 79) caption += "=";
        if(!quiet) System.out.println(caption);


        for(int size = lowSize; size <= highSize; size++) {

            // create track with width and height = 'size', meaning that there
            // is size^2 legal positions
	    /*if (size % 2 == 0) {
		bl.x = bl.y = - size / 2; 
		tr.x = tr.y = (size / 2) - 1;
		} else {*/
		bl.x = bl.y = - (size + 1) / 2;
		tr.x = tr.y =   (size + 1) / 2;
		//}
	    //bl.x = bl.y = - size;
	    //tr.x = tr.y =   size;
		
            // a single legal starting point at the middle left of the track
            lsp.clear();
            lsp.add(new Vector(1 - tr.x, 0));

            // a vertical goal of length 2 at the middle right of the track
            goal = new LineSegment(new Vector(tr.x - 1, 1),
                                   new Vector(0, -2));

            Track track = new Track(bl, tr, con, lsp, goal, cd);

            // activate algorithm
	    long startTime,endTime,avgRunTime = 0;
	    long[] runTime = new long[repeat+1];
	    Path path = new Path();
	    for(int r = 0; r <= repeat; r++) {
		startTime = System.currentTimeMillis();
		path = pf.findPath(track);
		endTime = System.currentTimeMillis();
		runTime[r] = (endTime - startTime);
	    }
	    for(int r = 0; r < runTime.length; r++) {
		avgRunTime += runTime[r];
	    }
	    avgRunTime /= runTime.length;
            if(quiet) System.out.println(size + " " + pf.getInfo().iterations + " " + avgRunTime);

            // print out results
            if(!quiet) {
                System.out.println("investigated moves: " + pf.getInfo().investigatedMoveCount);
                System.out.println("\nThe Path:                 " + path);
                try{
                    int[] moves = path.getMoves();
                    System.out.print("The " + moves.length + " moves: ");
                    for (int i = 0; i < moves.length -1; i++) {
                        System.out.print(moves[i] + ", ");
                    }
                    System.out.println(moves[moves.length - 1]);
                } catch (Exception e) {
                    System.out.println("No moves");
                }
            }
        }
    }	
}
