/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : AnalyzeBFS.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-16
 *       last changes : 2005-03-16
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package analysis;

// IMPORT ====================================================================
import algorithms.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class BFSAnalysis {

    private static boolean quiet = false;
    private static int repeat = 0;

    private static void printHelp() {
	System.out.println("java algorithms.BFSAnalysis [OPTION]");
	System.out.println("where [OPTION] is one of:");
	System.out.println("-q   quiet mode");
	System.out.println("-h   display this help and exit");
	System.out.println("-r # repeat the timeing # number of times");
	System.exit(0);
    }

    public static void main(String[] args) {

        // check command-line arguments
        if(args.length > 0) {
	    for(int i = 0; i < args.length; i++) {
		try {
		    if(args[i].equals("-q")) quiet = true;
		    else if(args[i].equals("-r") && args.length > (i+1)) {
			Integer parse = new Integer(args[i+1]);
			repeat = parse.intValue();
			i++;
		    }
		    else {
			printHelp();
		    }
		} catch(NumberFormatException e) {
		    printHelp();
		}
	    }
        }

	//testPathFinder(new DepthFirstSearch());
	testPathFinder(new BreadthFirstSearchNoSet());
        //testPathFinder(new BreadthFirstSearch());
        //testPathFinder(new BreadthFirstSearchPred());
        //testPathFinder(new BreadthFirstSearchArray());
        //testPathFinder(new BreadthFirstSearchArrayHash());
    }	

    private static void testPathFinder(PathFinder pf) {
        //long startTime, stopTime, runTime;
        PathFinderAnalysis analyzer = new PathFinderAnalysis();

        //startTime = System.currentTimeMillis();
        analyzer.iterationAnalysis(pf, 3, 51, quiet, 10);
        //stopTime = System.currentTimeMillis();
        //if(!quiet) System.out.println("tid: " + (stopTime - startTime));
    }
}
