/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : MinimalArray.java
 *             author : Jakob Schmid
 *          commenced : 2005-04-08
 *       last changes : 2005-04-08
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package algorithms.containers;

import model.*;
import tracks.*;
import java.lang.Math;

// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class MinimalArray {

    protected int width, height;
    protected int blx, bly; // bottom-left coords
    public int[] xOffset, yOffset; // offset array
    public boolean[][] array;

    public MinimalArray(Track track) {
        width   = track.getWidth();
        height  = track.getHeight();
        blx     = track.bottomLeft.x;
        bly     = track.bottomLeft.y;
        xOffset = createOffsets(width);
        yOffset = createOffsets(height);
        array = new boolean[configurationCountInOneDimension(width)]
                           [configurationCountInOneDimension(height)];
    }

    public void add(Configuration conf) {
        array[xOffset[conf.a.x - (blx + 1)] + conf.v.x]
             [yOffset[conf.a.y - (bly + 1)] + conf.v.y] = true;
    }
    
    public boolean member(Configuration conf) {
        return array[xOffset[conf.a.x - (blx + 1)] + conf.v.x]
                    [yOffset[conf.a.y - (bly + 1)] + conf.v.y];
    }

    public int possibleVelocitiesAt(int n) { // first position is 0
        return (int) Math.floor(.5 + Math.sqrt(2 * (n + 1)));
    }

    public int maxLeftVelocityAt(int n, int size) { // first position is 0
        return (int) Math.floor(.5 + Math.sqrt(2 * (size - n))) - 1;
    }

    public int configurationCountAt(int n, int size) { // first position is 0
        return possibleVelocitiesAt(n) + possibleVelocitiesAt(size - n - 1) - 1;
    }

    protected int configurationCountInOneDimension(int size) {
        int cc = 0;
        for(int i = 0; i < size; i++) {
            cc += possibleVelocitiesAt(i);
            //System.out.println("maxvel at " + i + " is = " + possibleVelocitiesAt(i));
        }
        return cc * 2 - size;
    }

    protected int[] createOffsets(int size) {
        int[] offset = new int[size];
        // the max left velocity at position 0 is equal to the
        // max right velocity at the rightmost position (size-1)
        offset[0] = possibleVelocitiesAt(size-1) - 1;
        for(int n = 1; n < size; n++) {
            // offset[n] = offset[n-1] - max left velocity at (n - 1)
            //           + # of confs at (n - 1) + max left velocity at (n)
            offset[n] = offset[n-1] - maxLeftVelocityAt(n - 1, size)
                + configurationCountAt(n - 1, size) + maxLeftVelocityAt(n, size);
        }
        return offset;
    }
}
