package algorithms;

import java.util.ArrayList;
import model.*;
import tracks.*;
import util.Move;
import algorithms.containers.*;

public class DepthFirstSearch implements PathFinder {

    private int iterations = 0;
    private Track track;

    public Path findPath(Track track) {
	this.track = track;
	Vector start = (Vector)track.legalStartingPoints.get(0);
	return dfs(new Configuration(start,new Vector()), new Set());
    }

    private Path dfs(Configuration conf, Set S) {
	Vector A = conf.a; // position
	Vector V = conf.v; // velocity
	LineSegment lineseg = new LineSegment(A,V);
	Path path = new Path();
	if (track.crash(lineseg) || S.member(conf)) {
	    return path;
	} else {
	    if (track.passesGoalLine(lineseg) 
		&& !track.startsFromLegalStartingPoint(lineseg)) {
		path.add(conf);
		return path;
	    } else {
		S.add(conf);
		Vector ai = Move.acceleration(1);
		Configuration newConf = new Configuration(A.add(V),V.add(ai));
		path = dfs(newConf,S);
		for(int i = 2; i <= 9; i++) {
		    ai = Move.acceleration(i);
		    newConf = new Configuration(A.add(V),V.add(ai));
		    Path newPath = dfs(newConf,S);
		    if (newPath.size() != 0 && newPath.size() < path.size()){
			path = newPath;
		    } 
		}
	    }
	}
	return path;
    }
    
    public PathFinderInfo getInfo() {
        PathFinderInfo info = new PathFinderInfo();
        info.iterations = iterations;
        return info;
    }
}