/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : BreadthFirstSearch.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-04
 *       last changes : 2005-03-16
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package algorithms;

// IMPORT ====================================================================
import java.util.ArrayList;
import model.*;
import tracks.*;
import util.Move;
import algorithms.containers.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class BreadthFirstSearchPred implements PathFinder{

    private int iterations;

    public Path findPath(Track track)
    {
        iterations = 0;
	Queue Q = new Queue();
	ConfigurationPairSet S = new ConfigurationPairSet();

        Configuration conf = new Configuration(
                 (Vector) track.legalStartingPoints.get(0), new Vector());
	Q.enQueue(conf);
	S.add(new ConfigurationPair(conf, null));
	while (!Q.isEmpty()) {
            iterations++;
	    conf = (Configuration) Q.deQueue();
	    Vector A = conf.a;
	    Vector V = conf.v;
	    for(int i = 1; i <= 9; i++) {
		Vector ai = Move.acceleration(i);
		LineSegment lineseg = new LineSegment(A,V.add(ai));
		Configuration newConf = new Configuration(A.add(V.add(ai)),
							  V.add(ai),i);
		if (!track.crash(lineseg) && !S.pairMember(newConf)) {
                    // win
		    if (track.passesGoalLine(lineseg) 
			&& !track.startsFromLegalStartingPoint(lineseg)) {
			S.add(new ConfigurationPair(newConf, conf));
			return constructPath(S);
		    } else {
			Q.enQueue(newConf);
			S.add(new ConfigurationPair(newConf, conf));
		    }
		}
	    }
	}
	return null;
    }

    private Path constructPath(ConfigurationPairSet  S) {
	ConfigurationPair confPair;
	int remainder = S.size() -1;
	Path path = new Path();

	confPair = S.get(remainder);
	//System.out.println("" + confPair.conf);
	path.add(confPair.conf);

	while (remainder > 0) {
	    remainder--;
	    while (!confPair.pred.equals(S.get(remainder).conf)) {
		remainder--;
		try {
		    if (remainder < 0) {
			throw new Exception();
		    }
		} catch (Exception e) {
		    System.out.println("ERROR: Predecessor not found" + e);
		}
	    }
	    confPair = S.get(remainder);
	    path.add(confPair.conf);
	}

	Path reversed = new Path();
	for(int i = path.size()-1; i >= 0; i--)
	    reversed.add((Configuration) path.get(i));

	return reversed;
    }

    public PathFinderInfo getInfo() {
        PathFinderInfo info = new PathFinderInfo();
        info.iterations = iterations;
        return info;
    }
}
